--[[
 *
 * Copyright (c) 2015 - atom0s [atom0s@live.com]
 *
 * GDHook is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GDHook is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GDHook.  If not, see <http://www.gnu.org/licenses/>.
 *
]]--

require 'mathex'
settings = require 'settings'
require 'stringex'
require 'tableex'

---------------------------------------------------------------------------------------------------
-- desc: Switch Case for Lua (Credits: Unknown Author)
---------------------------------------------------------------------------------------------------
function switch(c)
    local switch_table = 
    {
        casevar = c,
        caseof = function(self,code)
            local f;
            if (self.casevar) then
                f = code[self.casevar] or code.default;
            else
                f = code.missing or code.default;
            end
            if f then
                if (type(f) == 'function') then
                    return f(self.casevar,self);
                else
                    error('case: ' .. tostring(self.casevar) .. ' is not a function!');
                end
            end
        end
    };
    return switch_table
end
